
; Mains Power Up and Sequencer
; sequences mains power applied to outlets

; offset from precision rectifier and direction of off sequence
; is set when powered up with VR1 set fully clockwise (no load connected)
; off sequence is 4321 with S3 closed and 1234 with S3 open.  
 

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F1459
	#include p16f1459.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_ON & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF &_IESO_OFF & _FCMEN_OFF

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _WRT_OFF & _CPUDIV_NOCLKDIV & _USBLSCLK_24MHz & _PLLMULT_4x & _PLLEN_DISABLED & _STVREN_ON & _BORV_HI & _LPBOR_OFF & _LVP_OFF 

;..................................................................................................................................
; define;
; Bank 0 RAM 
; Stored data
ON_SEQ_RATE			equ	H'20'		; rate of switching on outputs
OFF_SEQ_RATE		equ	H'21'		; rate of switching off outputs
OFFSET0				equ	H'22'		; MCP6272 offset ms byte 
OFFSET1				equ	H'23'		; MCP6272 offset ls byte
DIRECTION			equ	H'24'		; off sequence direction

; A/D readings
POTENTIOMETER		equ H'25'		; trimpot VR1 value
CURRENT0			equ	H'26'		; current detect or daisy chain input voltage ms byte
CURRENT1			equ	H'27'		; current detect or daisy chain input voltage ls byte
MULTIPLIER			equ	H'28'		; delay multiplier
VALUEI				equ	H'29'		; working value for comparison
NUMBER				equ	H'2A'		; number of outlets selected at RA0,RA1

; All Banks RAM
READADDMS 			equ	H'70'		; ms Byte of Program Address to read from Flash
READADDLS			equ	H'71'		; ls byte of program address to read from Flash
TEMP_VAL			equ	H'72'		; temporary value for ms byte in read and A/D conversion ms byte store 
LOOP				equ	H'73'		; flash write memory bytes
STORE1				equ	H'74'		; delay counter	1
STORE2				equ	H'75'		; delay counter 2
TEMP				equ	H'76'		; temporary register for delay in A/D conversion

; initial values

	org	H'1F80'		; initial address from which data is stored (High Endurance Flash location in each ls byte)

	DA	H'3F2F'		; on sequence rate (2F= ~0.5s)
	DA	H'3F2F'		; off sequencer rate (2F= ~0.5s)
	DA	H'3F00'		; offset current detection op amp, ms byte in last 8-bits
	DA	H'3F00'		; offset current detection op amp, ls byte in last 8-bits
	DA	H'3F01'		; off sequence: forward (1234) or reverse (4321) off sequence 
					; (initially reverse)

;.................................................................
	org		0
	goto	MAIN
	org     4				; interrupt vector @ 4
	nop

MAIN

; set inputs/outputs
	movlb	D'2'			; latch, bank 2
	movlw	B'00000000'	; 
	movwf	LATA
	movlw	B'00000000'	; 
	movwf	LATB
	movlw	B'00000000'	; 
	movwf	LATC

;USB
	movlb	D'29'
	bcf		UCON,3		; USB off
	bcf		UCON,1
	
; weak pullups off/on
	movlb	D'4'		; bank4	WPUA/B
	clrf	WPUA
	movlw	B'11100000' ; RB7,RB6,RB5 to S2,S3,S1
	movwf	WPUB

; set I/O
	movlb	D'1'		; bank1	TRISA/B/C
	movlw   B'00000000'	; I/O 
	movwf   TRISA		; port A data direction register
	movlw	B'11100000'	; I/O 
	movwf	TRISB		; port B data direction register
	movlw	B'00001001'
	movwf	TRISC		; port C data direction 
; options
	movlw	B'00000111'	; weak pullups set via WPUA/B TMR0/256
	movwf	OPTION_REG	; 
; analog inputs
	movlb	D'3'		; bank3	ANSELA/B/C  AN4, AN7
	movlw	B'00000000'	; 
	movwf	ANSELA
	movlw	B'00000000' ; 
	movwf	ANSELB
	movlw	B'00001001'	; AN7,AN4  VR1,Current/daisy chain voltage
	movwf	ANSELC
; A/D select
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011100'	; channel 7 start 
; 00010000 	; channel 4	; Current detection or Daisy chain voltage
; 00011100	; channel 7	; VR1
	movwf	ADCON0
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on

; oscillator	
	movlw	B'00110100'	; for 4MHz;
	movwf	OSCCON		; osc

; short start up delay
	call	DELAYms			; 100ms
		
; read values from flash

; ON_SEQ_RATE	; rate of switching on of successive GPO mains outlets
	movlw	H'1F'		; ms address byte 
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
	movwf	ON_SEQ_RATE
; OFF_SEQ_RATE	; rate of switching off of successive GPO mains outlets
	movlw	H'81'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
	movwf	OFF_SEQ_RATE
; OFFSET ms byte. Using ls byte in 14-bit data
	movlw	H'82'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
	movwf	OFFSET0		; ms byte
; OFFSET ls byte. Using ls byte in 14-bit data
	movlw	H'83'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
	movwf	OFFSET1		; ls byte
; DIRECTION 
	movlw	H'84'
	movwf	READADDLS	; ls address byte
	call	READ		; 'w' has data for ls byte (8-bits)
	movwf	DIRECTION

; A/D conversion
; Channel 7 A/D value for VR1

	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00011100'	; channel 7  
; 00011100	; channel 7	; VR1
	movwf	ADCON0
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on
	bcf		INTCON,GIE

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT1
	decfsz	TEMP,f
	goto	WAIT1	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	movf	ADRESH,w
	btfsc	STATUS,Z		; if 0 set at 1
	movlw	D'1'
	movlb	D'0'			; bank 0
	movwf	POTENTIOMETER	; store value

; if >253. store offset reading from MCP6272 output (for op amp offset) and DIRECTION
	sublw	D'253'
	btfsc	STATUS,C
	goto	BY_OFFSET

; OFFSET read and store

; Get offset
; check AN4 for offset	
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00010000'	; channel 4 Current detection/Daisy chain voltage
	movwf	ADCON0
	movlw	B'10010000'	; right justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON	; A/D on

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT2
	decfsz	TEMP,f
	goto	WAIT2	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV2
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV2
	movf	ADRESH,w		; ms byte
	movwf	TEMP_VAL
	movf	ADRESL,w		; ls byte
	movlb	D'0'			; bank 0
	movwf	CURRENT1		; op amp output
	movf	TEMP_VAL,w		; ms byte
	movwf	CURRENT0


DO_STORE
; place into stored Flash memory (WRITE)
	movf	CURRENT0,w 		; write to memory
	movwf	OFFSET0
	movf	CURRENT1,w
	movwf	OFFSET1

; determine off sequence First On First Off or First On Last Off
	clrf	DIRECTION		; FOFO
	btfsc	PORTB,6			; if S3 closed then reverse sequence FOLO
	bsf		DIRECTION,0
	call	STORE			; store offset and direction values. No change to sequence rates for on and off  

WAIT
	goto	WAIT			; stops here

BY_OFFSET
; check switch S3 at RB6. Closed (low) is off sequence rate, open (high) is on Sequence rate
CK_S3
	btfss	PORTB,6
	goto	CF_OFF_RATE
;
; compare on sequence rate with VR1 reading (POTENTIOMETER)
; if different then store VR1 value	
	movf	POTENTIOMETER,w
	xorwf	ON_SEQ_RATE,w
	btfsc	STATUS,Z
	goto	CONTINUE1			; same so bypass storing Potentimter (VR1) value in ON_SEQ_RATE 
	movf	POTENTIOMETER,w
	movwf	ON_SEQ_RATE
	call	STORE				; place in Flash
	goto	CONTINUE1

CF_OFF_RATE
; compare off sequence rate with VR1 reading (POTENTIOMETER)
; if different then store VR1 value	
	movf	POTENTIOMETER,w
	xorwf	OFF_SEQ_RATE,w
	btfsc	STATUS,Z
	goto	CONTINUE1			; same so bypass storing Potentiometer (VR1) value in SEQUENCE_RATE 
	movf	POTENTIOMETER,w
	movwf	OFF_SEQ_RATE
	call	STORE				; place in Flash
	
CONTINUE1
; current detect loop
I_DETECT_LOOP	

; check if S1 (RB5 low) closed for Current or daisy chain detect  
	btfsc	PORTB,5
	goto	CONTINUE2		; no current or Daisy input detect required

; check AN4 for current	
	movlb	D'1'			; bank1	ADCON0/1/2
	movlw	B'00010000'		; channel 4 Current detection/Daisy chain voltage
	movwf	ADCON0
	movlw	B'10010000'		; right justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON		; A/D on

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT3
	decfsz	TEMP,f
	goto	WAIT3	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV3
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV3
	movf	ADRESH,w		; ms byte
	movwf	TEMP_VAL		; store in all banks RAM
	movf	ADRESL,w		; ls bits
	movlb	D'0'			; bank 0
	movwf	CURRENT1		; ls byte
	movf	TEMP_VAL,w
	movwf	CURRENT0		; ms byte of current detect or daisy chain voltage

; check for low current. 

; subtract offset from current reading	

	movf	OFFSET0,w		; high byte
	subwf	CURRENT0,f		; subtraction
	movf	OFFSET1,w		; low byte
	subwf	CURRENT1,f		; subtraction
	btfss	STATUS,C
	decf	CURRENT0,f		; reduce high byte subtraction if carry	
	btfsc	CURRENT0,7		; if set then a negative value so stay off
	goto	I_DETECT_LOOP

; COMPARE
; check if high enough

	movlw	H'00'
	subwf	CURRENT0,w		; subtraction
	movwf	VALUEI			; keep subtraction
	movlw	D'8'			; low byte
	subwf	CURRENT1,w		; subtraction
	btfss	STATUS,C
	decf	VALUEI,f		; reduce high byte subtraction if carry	
	btfsc	VALUEI,7		; if clear then positive so switch on
	goto	I_DETECT_LOOP


SWITCH_ON	; when current high enough, allow start
CONTINUE2
; check S2 (RB7) if low for startup delay or not (high) for start now
; startup delay
	btfsc	PORTB,7
	goto	NOW_STRT

; add in on sequence rate for startup (used for daisy chain version)
	call	S_ON_D			; switch on delay

NOW_STRT
; switch on GPO1 (RC1 high , then RA4 high then after relay switch on time (>20ms)RC1 low), 

; determine number of outlets set at RA1,RA0
	movf	PORTA,w
	andlw	B'00000011'
	movwf	NUMBER
;..................................
; OUTLET GPO1
; RC1 then RA4, then RC1 off
	movlb	D'2'			; LATA
	bsf		LATC,1			; Triac1 on
	movlb	D'0'			; PORTA
	call	DELAYxms		; 300ms
; then RA4, then RC1 off
	movlb	D'2'			; LATA
	bsf		LATA,4			; RELAY1 on
	movlb	D'0'        	; PORTA
; delay before Triac off for time for relay closure	
	call	DELAYms			; 100ms
	movlb	D'2'			; LATA
	bcf		LATC,1			; Triac1 off

; compare 
	movlb	D'0'			; PORTA	
	movf	NUMBER,w
	xorlw	B'00000011'
	btfsc	STATUS,Z
	goto	END_ON			; just 1 outlet	
; On Sequence rate
	call	S_ON_D			; on sequence delay

;.................................
; then GPO2
; RC2 first then RA5, delay  RC2 off 
	movlb	D'2'			; bank LATA
	bsf		LATC,2			; TRIAC2 on
	movlb	D'0' 			; PORTA
	call	DELAYxms		; 300ms
; then RA5, then RC2 off
	movlb	D'2'			; LATA
	bsf		LATA,5			; RELAY2 on
	movlb	D'0' 			; PORTA
; delay before Triac off	
	call	DELAYms			; 100ms
	movlb	D'2'			; LATA
	bcf		LATC,2			; Triac2 off
	
; compare 
	movlb	D'0'			; PORTA	
	movf	NUMBER,w
	xorlw	B'00000010'
	btfsc	STATUS,Z
	goto	END_ON			; just 2 outlets
	call	S_ON_D			; on sequence delay

;.................................
; then GPO3 (RB4 ,RC5)
	movlb	D'2'			; bank LATA
	bsf		LATB,4			; TRIAC3 on
	movlb	D'0' 			; PORTA
	call	DELAYxms		; 300ms
; then RA5, then RC2 off
	movlb	D'2'			; LATA
	bsf		LATC,5			; RELAY3 on
	movlb	D'0' 			; PORTA
; delay before Triac off	
	call	DELAYms			; 100ms
	movlb	D'2'			; LATA
	bcf		LATB,4			; Triac3 off
	
; compare 
	movlb	D'0'			; PORTA	
	movf	NUMBER,w
	xorlw	B'00000001'
	btfsc	STATUS,Z
	goto	END_ON			; just 3 outlets
; Sequence rate
	call	S_ON_D			; on sequence delay

;........................................
; then GPO4 (RC7, RC6)
	movlb	D'2'			; bank LATA
	bsf		LATC,7			; TRIAC4 on
	movlb	D'0' 			; PORTA
	call	DELAYxms		; 300ms 
; then RA5, then RC2 off
	movlb	D'2'			; LATA
	bsf		LATC,6			; RELAY4 on
	movlb	D'0' 			; PORTA
; delay before Triac off	
	call	DELAYms			; 100ms
	movlb	D'2'			; LATA
	bcf		LATC,7			; Triac4 off
	movlb	D'0' 			; PORTA

;.............................................

END_ON	; end of outlets on
	call	DELAYms

; check if S1 (RB5 low) closed and if so check for no current/daisy voltage, 
; and switch off outputs if below threshold in sequence	
; otherwise SLEEP
	btfsc	PORTB,5			; if closed check current
	SLEEP					; powers off with input power off

; Power off detect
POWER_OFF_DETECT
; check AN4 for current	
	movlb	D'1'			; bank1	ADCON0/1/2
	movlw	B'00010000'		; channel 4 Current detection/Daisy chain voltage
	movwf	ADCON0
	movlw	B'10010000'		; right justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf		ADCON0,ADON		; A/D on

; wait >20us to charge input capacitance
	movlw	D'11'
	movwf	TEMP
WAIT4
	decfsz	TEMP,f
	goto	WAIT4	
	bsf		ADCON0,1		; GO/DONE bit start conversion
WAIT_CONV4
	btfsc	ADCON0,1		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV4
	movf	ADRESH,w
	movwf	TEMP_VAL
	movf	ADRESL,w		; ls bits
	movlb	D'0'			; bank 0
	movwf	CURRENT1		; ls byte
	movf	TEMP_VAL,w
	movwf	CURRENT0		; ms byte, current detect or daisy chain voltage

; check for low current. 

; subtract offset from current reading	

	movf	OFFSET0,w		; high byte
	subwf	CURRENT0,f		; subtraction
	movf	OFFSET1,w		; low byte
	subwf	CURRENT1,f		; subtraction
	btfss	STATUS,C
	decf	CURRENT1,f		; reduce high byte subtraction if carry	
	btfsc	CURRENT0,7		; if set then a negative value so switch off
	goto	I_DETECT_LOOP

; compare against current values
	movlw	H'00'
	subwf	CURRENT0,w		; subtraction
	movwf	VALUEI			; keep subtraction
	movlw	H'04'			; low byte
	subwf	CURRENT1,w		; subtraction
	btfss	STATUS,C
	decf	VALUEI,f		; reduce high byte subtraction if carry	
	btfss	VALUEI,7		; if set then negative so switch off
	goto	POWER_OFF_DETECT

SWITCH_OFF
; switch off outputs 
; check S2 (RB7) if low for end delay or not (high) for end now
; ending delay
	btfsc	PORTB,7
	goto	NOW_END
	call	S_OFF_D			; switch off delay

NOW_END
; check if forward or reverse sequence
	btfss	DIRECTION,0
	goto	FORWARD

REVERSE ; sequence. First on last off 

; determine number of outlets set at RA1,RA0
	movf	PORTA,w
	andlw	B'00000011'
	movwf	NUMBER
; compare 
	xorlw	B'00000000'
	btfsc	STATUS,Z
	goto	REV_OFF_FOUR	; all four 4,3,2,1	

	movf	NUMBER,w
	xorlw	B'00000001'
	btfsc	STATUS,Z
	goto	REV_OFF_THREE	; 3,2 1

	movf	NUMBER,w
	xorlw	B'00000010'
	btfsc	STATUS,Z
	goto	REV_OFF_TWO		; 2,1
	
	goto	REV_OFF_ONE		; 1

; reverse off sequence

REV_OFF_FOUR

; Triac4 on, relay4 off, Triac4 off 
; GPO4
	movlb	D'2'			; bank LATA
	bsf		LATC,7			; Triac4 on
	call	DELAYms			; 100ms
	bcf		LATC,6			; Relay4 off
	call	DELAYms			; 100ms
	bcf		LATC,7			; Triac4 off
	call	S_OFF_D			; Switch Off Delay

REV_OFF_THREE
	
; Triac3 on, relay3 off, Triac3 off 
; GPO3
	movlb	D'2'			; bank LATA
	bsf		LATB,4			; Triac3 on
	call	DELAYms
	bcf		LATC,5			; Relay3 off
	call	DELAYms
	bcf		LATB,4			; Triac3 off
	call	S_OFF_D			; Switch Off Delay

REV_OFF_TWO

; Triac2 on, relay2 off, Triac2 off 
; GPO2
	movlb	D'2'			; bank LATA
	bsf		LATC,2			; Triac2 on
	call	DELAYms
	bcf		LATA,5			; Relay2 off
	call	DELAYms
	bcf		LATC,2			; Triac2 off
	call	S_OFF_D			; Switch Off Delay

REV_OFF_ONE

; Triac1 on, relay1 off, Triac1 off 
; GPO1
	movlb	D'2'			; bank LATA	
	bsf		LATC,1			; Triac1 on
	call	DELAYms
	bcf		LATA,4			; Relay1 off
	call	DELAYms
	bcf		LATC,1			; Triac1 off
	movlb	D'0'			; bank 0
	call	DELAYms
	goto	I_DETECT_LOOP	; check for current to start

;...................................................................

FORWARD ; off sequence. First on first off 

; determine number of outlets set at RA1,RA0
	movf	PORTA,w
	andlw	B'00000011'
	movwf	NUMBER

FOR_OFF_ONE
; Triac1 on, relay1 off, Triac1 off 
; GPO1	
	movlb	D'2'			; bank LATA	
	bsf		LATC,1			; Triac1 on
	call	DELAYms
	bcf		LATA,4			; Relay1 off
	call	DELAYms
	bcf		LATC,1			; Triac1 off
	movlb	D'0'			; PORTA			

; compare 
	movf	NUMBER,w
	xorlw	B'00000011'
	btfsc	STATUS,Z
	goto	END_FOR_OFF		; just 1 outlet	
	call	S_OFF_D			; Switch Off Delay

FOR_OFF_TWO
; Triac2 on, relay2 off, Triac2 off 
; GPO2
	movlb	D'2'			; bank LATA
	bsf		LATC,2			; Triac2 on
	call	DELAYms
	bcf		LATA,5			; Relay2 off
	call	DELAYms
	bcf		LATC,2			; Triac2 off
	movlb	D'0'			; PORTA		

	movf	NUMBER,w
	xorlw	B'00000010'
	btfsc	STATUS,Z
	goto	END_FOR_OFF		; just 2 outlets	
	call	S_OFF_D			; Switch Off Delay

FOR_OFF_THREE
; Triac3 on, relay3 off, Triac3 off 
; GPO3
	movlb	D'2'			; bank LATA
	bsf		LATB,4			; Triac3 on
	call	DELAYms
	bcf		LATC,5			; Relay3 off
	call	DELAYms
	bcf		LATB,4			; Triac3 off

	movlb	D'0'			; PORTA		
	movf	NUMBER,w
	xorlw	B'00000001'
	btfsc	STATUS,Z
	goto	END_FOR_OFF		; just 3 outlets
	call	S_OFF_D			; Switch Off Delay

FOR_OFF_FOUR
; Triac4 on, relay4 off, Triac4 off 
; GPO4
	movlb	D'2'			; bank LATA
	bsf		LATC,7			; Triac4 on
	call	DELAYms			; 100ms
	bcf		LATC,6			; Relay4 off
	call	DELAYms			; 100ms
	bcf		LATC,7			; Triac4 off

END_FOR_OFF; end of forward off sequence

	movlb	D'0'			; bank 0
	call	DELAYms
	goto	I_DETECT_LOOP	; check for current to start

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

S_ON_D		; Switch On Delay
	movlb	D'0'			; bank 0
	movlw	D'28'			; start at higher setting (~0.5V)
	subwf	ON_SEQ_RATE,w
	btfss	STATUS,C
	movlw	D'1'			; use 1 if negative or 0
	btfsc	STATUS,Z
	movlw	D'1'
	movwf	MULTIPLIER		; working counter

LOOP_ON
	call	DELAYms
	decfsz	MULTIPLIER,f
	goto	LOOP_ON

	return


S_OFF_D		; Switch Off Delay
	movlb	D'0'			; bank 0
	movlw	D'28'
	subwf	OFF_SEQ_RATE,w
	btfss	STATUS,C
	movlw	D'1'			; use 1 if negative or 0
	btfsc	STATUS,Z
	movlw	D'1'
	movwf	MULTIPLIER		; working counter

LOOP_OFF
	call	DELAYms
	decfsz	MULTIPLIER,f
	goto	LOOP_OFF

	return

;/////////////////////////////////////////////////////////////

; delay loop 

DELAYxms
	movlw	D'3'		; 300ms
	movwf	TEMP_VAL
DLYLOOP
	call	DELAYms
	decfsz	TEMP_VAL,f
	goto	DLYLOOP

DELAYms ; 100ms/ cycle
	movlw	D'186'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B2'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return


;....................................................................
STORE ; store values from RAM to Flash

; Flash high endurance locations	
	movlw	H'1F'			; ms address byte 
	movwf	READADDMS 
	movlw	H'80'
	movwf	READADDLS		; ls address byte

; start of RAM
	movlw	H'20'
	movwf	FSR0H
	movlw 	H'00'
	movwf	FSR0L

; write to data memory
WRITE
	clrf	LOOP			; counter

; load write latches
	movlb	D'03'			; bank 3
	movf	READADDMS,W		; Load upper 6 bits of address boundary			
	movwf	PMADRH ;
	movf	READADDLS,W 	; Load lower 8 bits of erase address boundary
	andlw	B'11110000'		; clear ls bits to start of ID memory
	movwf	PMADRL ;

; erase first
	bcf		PMCON1,CFGS 	; Not configuration space
	bsf		PMCON1,FREE 	; Specify an erase operation
	bsf		PMCON1,WREN 	; Enable writes
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2 			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin erase
	nop					 	; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	 
	bcf		PMCON1,WREN 	; Disable writes

; load latches
	movf	READADDMS,W		; Load upper 6 bits of  address boundary			
	movwf	PMADRH ;
	movf	READADDLS,W 	; Load lower 8 bits of erase address boundary
	andlw	B'11110000'		; clear ls bits to start of ID memory
	movwf	PMADRL ;

	bcf		PMCON1,CFGS		; Not configuration space
	bsf		PMCON1,WREN	 	; Enable writes
	bsf		PMCON1,LWLO 	; Only Load Write Latches

LOOPW
	moviw	FSR0++ 			; Load first data byte into lower
	movwf	PMDATL ;
	movlw	H'3F'	 		; Load second data byte into upper always 3F
	movwf	PMDATH ;		; Load second data byte into upper

	movf	LOOP,w		 	; Check lower bits of address
	xorlw	0x04			; Check if we're on the last of addresses
	btfsc	STATUS,Z 		; Exit if last of words,
	goto	START_WRITE ;

	movlw	H'55'		 	; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin write
	nop					 	; nop instructions are forced as processor loads program memory write latches
	nop ;
	incf	PMADRL,f	 	; Still loading latches Increment address
	incf	LOOP,f
	goto	LOOPW

START_WRITE ; write
	bcf		PMCON1,LWLO		; No more loading latches - Start Flash program
; memory write
	movlw	H'55'			; Start of required write sequence:
	movwf	PMCON2 			; Write 55h
	movlw	H'AA' ;
	movwf	PMCON2 			; Write AAh
	bsf		PMCON1,WR 		; Set WR bit to begin write
	nop						; NOP instructions are forced as processor writes all the program memory write latches simultaneously to program memory.
	nop	  
	bcf		PMCON1,WREN 	; Disable writes
	movlb	D'0'			; bank 0
	return

;.......................................................................................
; read data memory
READ; 'w' has read data

	movlb	D'3'		;  bank 3 
	movf	READADDMS,w 
	movwf 	PMADRH		; ms Byte of Program Address to read
	movf	READADDLS,w
	movwf 	PMADRL 		; ls Byte of Program Address to read
	bcf		PMCON1,CFGS	; avoid configuration space
	bsf	 	PMCON1,RD 	; Read
	nop 					
	nop
; memory is read in second cycle PM read instruction
	movf	PMDATH,w 	; ms Byte of Program data 
	movwf	TEMP_VAL	; ms byte of data in TEMP_VAL
	movf	PMDATL,w 	; ls Byte of Program data in 'w'
	movlb	D'0'		; bank 0
	return



 end